function [processed]=subdatapreprocessing(mzaxis,subdataraw,tophat,pixelnum);
%This program will remove baseline shifts from your data using the
%tophat  algorithm.  It will also log-transform the data.  A plot will be
%generated that shows the original data in blue and your processed data
%(log-transformed, background subtracted/filtered) in red for a 
%specific maldi imaging pixel.


%INPUTS
%mzaxis - this is your m/z axis of the data.  If you trimmed and/or
%downsampled your data, then this input would be corresponding mass axis.

%subdataraw - this is a matrix of your mz spectra.  In our protocol, this 
%matrix contains the  spectra of only the relevant pixels.  Again, these
%raw spectra may be trimmed and/or Gaussian smoothed and/or downsampled.

%tophat - this is a number that sets the value of the tophat window.  A
%large number wil make a larger window, allowing wider peaks to pass (which
%could worsen the ability of the filter to remove baselines).  A small
%number will give a smaller window, allowing skinnier peaks to pass through
%(potentially losing some of your data).  250 is a good ball park number to
%start with, but it really depends on the m/z resolution.

%pixelnum - this is a number that refers to a specific pixel you wish to
%plot the mass spectrum of when looking at your data.  Any pixel number
%will work.  If you happen to know the row number of a good spectrum, use
%this.  If not, choose a random pixel number.


%OUTPUTS
%processed - this is a matrix of your log-transformed, baseline 
%subtracted data. Each row is a mz spectrum and each column is a specific 
%mass to charge ratio.

%First take the log of your data:
subdataraw=log10(subdataraw);
%These commands remove baseline through tophat filtering.
[aa,bb]=size(subdataraw);
se = strel('line',tophat,0);
for x=1:aa
    processed(x,:)=imtophat(subdataraw(x,:),se);
end

%These commands plot the before processing and after processing traces in
%blue and red, respectively.
figure
plot(mzaxis,subdataraw(pixelnum,:),'LineWidth',2)
hold
plot(mzaxis,processed(pixelnum,:),'r','LineWidth',2)
legend('Log Original','Log Processed')
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Log10 of Intensity','FontSize',16)